<?php
require_once  dirname(__DIR__, 1) . '/pdf/db_connection.php';
require_once  dirname(__DIR__, 1) . '/fpdf/fpdf.php';
$conn = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
if ( !$conn ) {
	die( 'Not Connected: ' . mysql_error());
}
$invoice = $table_prefix . 'cip_member_invoice';
$account = $table_prefix . 'sm_accounts_management';
$site = get_site_url();
$header_img = $site."/wp-content/uploads/2021/10/Asset-10.png";
$paid_img = $site."/wp-content/uploads/2021/10/Asset-20-1.png";
define('EURO',chr(128));
class PDF extends FPDF{
// 	function Footer()
// 	{
// // 		$this->SetY(-20);
// // 		$this->SetFont('Arial','I',9);
// // 		$this->SetTextColor(140, 140, 140);
// // 		$this->MultiCell(0,5,'CSR Services Europe OU Registered in Estonia number 16317035
// // 		Keemia 4, Tallinn, 10616 Estonia',0,'C');
// 	}
	function SetCellMargin($margin){
		// Set cell margin
		$this->cMargin = $margin;
	}
}
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','B',15);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetLeftMargin(12);
// $pdf->SetDrawColor(204, 204, 204);

$pdf->Image($header_img,12,18,45);

if((isset($_GET['id'])) || (isset($_GET['key']))){
	$id = $_GET['id'];
	$key = $_GET['key'];
	$email= ( !empty( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-';
	if ($id){
		
		if( isset( $_GET['paid'] ) && $_GET['paid'] == 1 ){
			$type = "Invoice";
		}
		
		if( current_user_can('supportagent') ){
			$sel_invoice = "SELECT * FROM $invoice WHERE id='$id'";
		}else{			
			$sel_invoice = "SELECT * FROM $invoice WHERE id='$id' AND Email='$email'";
		}
	}else{
		$sel_invoice = "SELECT * FROM $invoice WHERE UniqueKey=$key";
	}
	$result = mysqli_query($conn, $sel_invoice);
	$count_rows = mysqli_num_rows($result);
	if($count_rows){
		while($row = mysqli_fetch_assoc($result)){
			$status = $row['Status'];
			$pdf->SetLeftMargin(118);
			if($status == 'Paid' && $type == 'Invoice'){
				
				$pdf->Cell(80,2,'', "T,L,R,0","1","L");
				$pdf->Cell(80,10,'   Invoice #' . $row['InvoiceNumber'], "L,R,0,0","1","L");
				$pdf->Cell(80,2,'', "T,L,R,0","1","l");
				$pdf->SetTextColor(0, 0, 0);
				$pdf->SetFont( 'Arial', '', 12 );
				$pdf->Cell(35,6,'   Date: ', "L,0,0,0","0","l");
				$pdf->SetFont( 'Arial', '', 12 );
				$pdf->Cell(45,6, $row['PaidDate'], "0,R,0,0","1","l");
				$pdf->Cell(35,6,'   Reference: ', "L,0,0,0","0","l");
				$pdf->SetFont( 'Arial', '', 12 );
				$pdf->MultiCell(45,6, "CSR-PO-" . $row['ProformaInvoiceNumber'], "0,R,0,0","l");
			}
			else{
				$pdf->Cell(80,2,'', "T,L,R,0","1","L");
				$pdf->Cell(80,10,'   Purchase Order', "L,R,B,0","1","L");
				
				$pdf->SetTextColor(0, 0, 0);
				$pdf->SetFont( 'Arial', '', 12 );
				$pdf->Cell(80,2,'', "0,L,R,T","1","l");
				$pdf->Cell(35,6,'   Date: ', "L,0,0,0","0","l");
				$pdf->Cell(45,6, $row['Date'], "0,R,0,0","1","l");
				$pdf->Cell(35,6,'   Reference: ', "L,0,0,0","0","l");
				$pdf->MultiCell(45,6, "CSR-PO-" . $row['ProformaInvoiceNumber'], "0,R,0,0","l");
			}

			$pdf->Cell(35,6,'   VAT Number: ', "L,0,0,0","0","l");
			$pdf->MultiCell(45,6, 'EE102417928', "0,R,0,0","l");
			$pdf->Cell(80,2,' ', "L,R,B,0","0","l");
			$pdf->SetLeftMargin(12);
			$pdf->Ln( 8 );
			
			
			$pdf->SetFont('Arial','B',14);
			
			$pdf->Cell(93,12,'   Supplier', "T,R,B,L","0","l");
			$pdf->Cell(93,12,'   Supporter', "T,R,B,0","1","l");
			$pdf->SetFont('Arial','B',11);
			$pdf->Cell(93,8,'   CSR Services Europe OU ', "0,R,0,L","0","l");
			$pdf->Cell(93,8,'   ' . $row['FirstName']." " .$row['LastName'] , "0,R,0,0","1","l");
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('Arial','',11);
			$pdf->MultiCell(93,8,"   Keemia 4", "0,R,0,L", "l");
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x + 93, $y);
			
			if($row['BusinessName']){
				$pdf->MultiCell(93,-8,'   ' . $row['BusinessName'], "0,R,0,0", "l");
			}
			else{
				$pdf->MultiCell(93,-8,'   ' . $row['Address1'], "0,R,0,L", "l");
			}
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x , $y+8);
			
			$pdf->Cell(93,8,'   Kristiine linnaosa', "0,R,0,L","0","l");
			if($row['BusinessName']){
				$pdf->Cell(93,8,'   ' . $row['Address1'].", " .$row['Address2'] , "0,R,0,0","1","l");
			}
			else{
				$pdf->Cell(93,8,'   '.$row['Address2'] , "0,R,0,L","1","l");
			}
			$pdf->MultiCell(93,8,'   Tallinn', "0,R,0,L", "l");
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x + 93, $y);
			$pdf->MultiCell(93,-8,'   ' . $row['City'].", " .$row['State'] , "0,R,0,0", "l");
			
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x , $y+8);

			$pdf->Cell(93,8,'   10616', "0,R,0,L","0","l");
			$pdf->Cell(93,8,'   ' . $row['Country'], "0,R,0,0","1","l");
	
			$pdf->MultiCell(93,8,"   Estonia", "0,R,0,L", "l");
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x + 93, $y);
			$pdf->MultiCell(93,-8,"   " . $row['Zipcode'], "0,R,0,L", "l");
			$pdf->SetTextColor(0, 0, 0);
			$pdf->Ln( 8 );
			$pdf->Cell(186,1,'  ', "T,0,0,0","1","l");

			$pdf->SetFont('Arial','B',14);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->Ln( 5 );
			$pdf->Cell(186,12,'   Plastic Neutrality package (' .$row['Kgs']. 'kg ' .$row['Package']. ') ', "T,L,R,0","1","l");
			$pdf->SetFont('Arial','B',11);
			$pdf->Cell(93,11,'   Price ('.EURO.')', "1","0","l");
			$pdf->SetFont('Arial','',11);
			$pdf->Cell(93,11,"   " . EURO . "  " . $row['ProductPrice'], "1","1","l");
			$pdf->SetFont('Arial','B',11);
			$pdf->Cell(93,11,"   VAT %: ", "0,L,R,B","0","l");
			$pdf->SetFont('Arial','',11);
			$pdf->Cell(93,11,"   " . $row['POVATPercentage'], "0,L,R,B","1","l");
			$pdf->SetFont('Arial','B',11);
			$pdf->Cell(93,11,"   VAT: ", "0,L,R,B","0","l");
			$pdf->SetFont('Arial','',11);
			$pdf->Cell(93,11,"   "  .EURO. " " . $row['VATAmount'], "0,L,R,B","1","l");
			$pdf->SetFont('Arial','B',11);
			$pdf->Cell(93,11,'   Total Payable ('.EURO.') ', "0,L,R,B","0","l");
			$pdf->SetFont('Arial','',11);
			$pdf->Cell(93,11,"   " .EURO. " " . $row['NetAmount'], "0,L,R,B","1","l");
			
			$assign_to=$row['BankId'];
			
			$sel_account = "SELECT * FROM $account WHERE id='$assign_to'";
			$result = mysqli_query($conn, $sel_account);
			$count_rows = mysqli_num_rows($result);
			

			/* if($count_rows == 1){
				$result = mysqli_query($conn, $sel_account);
			}
			else{
				$sel_rotation_account = "select * from $account where Status ='Active' order by Status limit 1";
				$result = mysqli_query($conn, $sel_rotation_account);
				$count_rows = mysqli_num_rows($result);
			} */
			
			if($count_rows){
				while($row = mysqli_fetch_assoc($result)){
					
					$pdf->SetTextColor(0, 0, 0);
					$pdf->SetFont( 'Arial', 'B', 14 );
					$pdf->Ln( 5 );
					$pdf->Cell(186,12,'   Bank Details', "T,L,R,0","1","l");

					$pdf->SetFont('Arial','',11);
					$pdf->SetTextColor(0,0,0);
					$pdf->Cell(93,11,'   Account Holder: ', "T,L,R,B","0","l");
					$pdf->MultiCell(93,11,"   " . $row['AccountHolder'], "T,L,R,B","l");

					$pdf->Cell(93,11,'   IBAN: ', "0,L,R,B","0","l");
					$pdf->MultiCell(93,11,"   " . $row['IBAN'], "0,L,R,B","l");

					$pdf->Cell(93,11,'   BIC: ', "0,L,R,B","0","l");
					$pdf->MultiCell(93,11,"   " . $row['BIC'], "0,L,R,B","l");

					$pdf->Cell(93,11,'   Bank Name: ', "T,L,R,B","0","l");
					$pdf->MultiCell(93,11,"   " . $row['BankName'], "T,L,R,B","l");

                    $str = $row['BankAddress'];
					$a = strlen($str);

					if(($a>36)&&($a<60)){
                        $pdf->Cell(93,14,'   Bank Address: ', "0,L,R,B","0","l");
						// CELL SPACING
						$pdf->setCellMargin(4);
						// END CELL SPACING
                        $pdf->MultiCell(93,7,$row['BankAddress'], "0,L,R,B","l");
                    }
					else if($a>60){
						$pdf->Cell(93,21,'   Bank Address: ', "0,L,R,B","0","l");
						// CELL SPACING
						$pdf->setCellMargin(4);
						// END CELL SPACING
                        $pdf->MultiCell(93,7,$row['BankAddress'], "0,L,R,B","l");
					}
                    else{
						$pdf->Cell(93,11,'   Bank Address: ', "0,L,R,B","0","l");
						// CELL SPACING
						$pdf->setCellMargin(4);
						// END CELL SPACING
						$pdf->MultiCell(93,11,$row['BankAddress'], "0,L,R,B","l");
					}
					$pdf->Ln( 12 );
					
				}
			}

			if($status == 'Paid' && $type == 'Invoice'){
				$pdf->Ln( 15 );
				$pdf-> Image($paid_img,108,260,90,30);
				$pdf->SetAutoPageBreak(false);
				$pdf->SetY(-17);
				$pdf->SetFont('Arial','I',8);
				$pdf->SetTextColor(140, 140, 140);
				$pdf->Cell(0,4,'CSR Services Europe OU Registered in Estonia number 16317035',0,1,'l');
				$pdf->Cell(0,4,'Keemia 4, Kristiine linnaosa, Tallinn, 10616 Estonia',0,1,'l');
			}
			else{
				$pdf->SetAutoPageBreak(false);
				$pdf->SetY(283);
				$pdf->SetFont('Arial','I',8);
				$pdf->SetTextColor(140, 140, 140);
				$pdf->Cell(0,4,'CSR Services Europe OU Registered in Estonia number 16317035',0,1,'C');
				$pdf->Cell(0,4,'Keemia 4, Kristiine linnaosa, Tallinn, 10616 Estonia',0,1,'C');
			}

		}
	}else{
		wp_redirect( site_url() );
		exit();
	}
}
$pdf->Output();
?>